package ch.frankel.blog.httpmethods;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/**
 * Servlet that checks for the type of HTTP method used.
 * 
 * @author <a href="http://blog.frankel.ch/">Nicolas Frankel</a>
 */
public class HttpMethodsServlet extends HttpServlet {

    /** Serial version unique identifier. */
    private static final long serialVersionUID = 1L;

    /** Key under which method names are stored. */
    private static final String METHODS_KEY = "methods";

    /** Method's index map. */
    private static final Map<String, Integer> METHODS_MAP;

    static {

        METHODS_MAP = new HashMap<String, Integer>(2);

        METHODS_MAP.put("PUT", 4);
        METHODS_MAP.put("DELETE", 5);
    }

    /**
     * @see HttpServlet#service(HttpServletRequest, HttpServletResponse)
     */
    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException,
            IOException {

        String[] methods = getMethodsKey(request);

        int i = 0;

        String param = request.getParameter("i");

        if (param != null) {

            i = Integer.parseInt(param);

        } else {

            Integer j = METHODS_MAP.get(request.getMethod());

            if (j != null) {

                i = j;

            } else {

                i = 6;
            }
        }

        methods[i] = request.getMethod();

        response.sendRedirect(request.getContextPath());
    }

    private String[] getMethodsKey(HttpServletRequest request) {

        HttpSession session = request.getSession();

        String[] methods = (String[]) session.getAttribute(METHODS_KEY);

        if (methods == null) {

            methods = new String[8];

            session.setAttribute(METHODS_KEY, methods);
        }

        return methods;
    }
}
